/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class BpaCage {
    private UnsignedInt8 mCageType;
    private UnsignedInt16 mCageStatus;
    private UnsignedInt8 mCageId;
    private String mTargetLocCode;
    private String mCageLocCode;
    private String mOwnerLocCode;
    private static final String CAGE_TYPE = "CAGE_TYPE";
    private static final String CAGE_STATUS = "CAGE_STATUS";
    private static final String CAGE_ID = "CAGE_ID";
    private static final String TAR_LOC_CODE = "TAR_LOC_CODE";
    private static final String CAGE_LOC_CODE = "CAGE_LOC_CODE";
    private static final String OWN_LOC_CODE = "OWN_LOC_CODE";

    BpaCage(Hashtable hashtable) {
        this.mCageType = (UnsignedInt8)hashtable.get(CAGE_TYPE);
        this.mCageStatus = (UnsignedInt16)hashtable.get(CAGE_STATUS);
        this.mCageId = (UnsignedInt8)hashtable.get(CAGE_ID);
        this.mTargetLocCode = (String)hashtable.get(TAR_LOC_CODE);
        this.mCageLocCode = (String)hashtable.get(CAGE_LOC_CODE);
        this.mOwnerLocCode = (String)hashtable.get(OWN_LOC_CODE);
    }

    public UnsignedInt8 getCageType() {
        return this.mCageType;
    }

    public UnsignedInt16 getCageStatus() {
        return this.mCageStatus;
    }

    public UnsignedInt8 getCageId() {
        return this.mCageId;
    }

    public String getCageMtms() {
        int n = this.mCageType.intValue();
        if (n != 255 && this.mCageLocCode != null && this.mCageLocCode.length() > 16) {
            return this.getMtmsFromLocCode(this.mCageLocCode);
        }
        return null;
    }

    public String getCageLocationCode() {
        if (this.mCageLocCode == null || this.mCageLocCode.length() < 1) {
            return null;
        }
        return this.mCageLocCode;
    }

    public String getFrameTargetLocationCode() {
        if (this.mTargetLocCode == null || this.mTargetLocCode.length() < 1) {
            return null;
        }
        return this.mTargetLocCode;
    }

    public String getOwnerMtms() {
        int n = this.mCageType.intValue();
        if (n == 32 || n == 33 || n == 34 || n == 47) {
            return this.getMtmsFromLocCode(this.mOwnerLocCode);
        }
        return null;
    }

    public String getOwnerLocationCode() {
        if (this.mOwnerLocCode == null || this.mOwnerLocCode.length() < 1) {
            return null;
        }
        return this.mOwnerLocCode;
    }

    private String getMtmsFromLocCode(String string) {
        if (string == null || string.length() < 17) {
            return null;
        }
        return string.substring(1, 5) + "-" + string.substring(6, 9) + "*" + string.substring(10, 17);
    }
}

